<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package vryn corp
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php global $vryn_opts;

 ?>

<div id="page" class="hfeed site container">

	<header id="masthead" class="site-header" role="banner">
			<?php
				if (strlen($vryn_opts['opt-logo']['url']) > 0)
				{
					$vryn_logo = "<img class='logo' src='".$vryn_opts['opt-logo']['url']."' alt='".esc_attr( get_bloginfo( 'name' ) )."' />";
					$vryn_class = "img";
				
				}
				else
				{
					$vryn_logo = get_bloginfo('name');
					$vryn_class = "text";
				}
				
			?>

		<div class="site-branding">
			<h1 class="site-title <?php echo $vryn_class; ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo $vryn_logo; ?></a></h1>
			<?php
			if (strlen($vryn_opts['opt-logo']['url']) == 0)
			{
			
			?>
			
			<h2 class="site-description <?php echo $vryn_desc; ?>"><?php bloginfo( 'description' ); ?></h2>
			<?php }?>
		</div>
		
		<div class="header-image">
			<div class="hdr-top-0">&nbsp;</div>
			<div class="hdr-top-1">
				<img src="<?php echo get_template_directory_uri(); ?>/images/topimg1.gif" alt="top image" />
			</div>
			<div class="hdr-top-2">
				<img src="<?php echo get_template_directory_uri(); ?>/images/topimg2.gif" alt="top image" />
			</div>
		</div>

		<nav id="site-navigation" class="main-navigation" role="navigation">
			<button class="menu-toggle"><?php _e( 'Menu', 'vryn-corp' ); ?></button>
			<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'vryn-corp' ); ?></a>

			<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
		</nav><!-- #site-navigation -->
	</header><!-- #masthead -->

	<div id="content" class="site-content">
