<?php

 /*
Template Name: Home Page Layout
*
* @package VRYN Photography
*/

get_header(); ?>

	<div class="container-fluid">
		<div class="row">
			<div class="container">
				<div class="row">
					<div class="boxes-3 clear">
						<div class="col-lg-4">
							<div class="column-three">
								<div class="column"><i class="fa fa-3x <?php echo of_get_option( 'box_column_font_1' ); ?>"></i></div>
								<div class="inner-column"><?php echo of_get_option( 'content_box_1', 'no entry' ); ?></div>
								<div class="column-link"><a href="<?php echo of_get_option( 'content_box_link_1' ); ?>">Read More...</a></div>
							</div>
						</div>
						<div class="col-lg-4">
							<div class="column-three">
								<div class="column"><i class="fa fa-3x <?php echo of_get_option( 'box_column_font_2' ); ?>"></i></div>
								<div class="inner-column"><?php echo of_get_option( 'content_box_2', 'no entry' ); ?></div>
								<div class="column-link"><a href="<?php echo of_get_option( 'content_box_link_2' ); ?>">Read More...</a></div>
							</div>
						</div>
						<div class="col-lg-4">
							<div class="column-three">
								<div class="column"><i class="fa fa-3x <?php echo of_get_option( 'box_column_font_3' ); ?>"></i></div>
								<div class="inner-column"><?php echo of_get_option( 'content_box_3', 'no entry' ); ?></div>
								<div class="column-link"><a href="<?php echo of_get_option( 'content_box_link_3' ); ?>">Read More...</a></div>
							</div>
						</div>
					 </div>
				</div>
			</div><!-- .container -->
		</div>
	</div>

		<div class="container-fluid gallery">
			<div class="row">
				<div class="container">
					<div class="row">
						<div class="gallery-title col-lg-12">
							<h2>Recent Works</h2>
						</div>
				<div class="col-lg-6-left clear">
	
			<?php
                    $wp_query= null;
                    $wp_query = new WP_Query();
$args = array(
	'posts_per_page' => 9,
	'post_status'=>'publish',
	'post__not_in' => get_option( 'sticky_posts' )
	
);
                    $wp_query->query($args);
                   
                    while ( have_posts() ) : the_post();
               ?>
					
                         <div class="small-image">
                         <?php
                      
 
						$imgsrc1 = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "home-gallery-thumbnail");
								 
						$imgsrc2 = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "home-gallery-zoomed");

$imgsmallpath = $imgsrc1[0];
$imgbigpath = $imgsrc2[0];
								 

						if((strlen($imgbigpath)==0))
            {
						$imgsmallpath = get_template_directory_uri()."/images/no-image.png";
						$imgbigpath = get_template_directory_uri()."/images/no-image.png";
            }

								echo "<a href='#' class='th-image' rel='{$imgbigpath}'><img src='{$imgsmallpath}' alt='Gallery Thumbnail' /></a>";
             
                                         
                                       
                                  
                                   ?>
                     
					</div>
               <?php
                    endwhile; // end of the loop.
                    wp_reset_postdata();wp_reset_query();
               ?> 
			   
					</div>
					<div class="col-lg-6-right clear">
						<div class="zoomed-image">
							<img height="345" src="<?php echo get_template_directory_uri(); ?>/images/no-image.png" alt="No image has been set" />
						</div>
					</div>
			   
						</div>
					</div>
				</div>
			</div>
	
	<div class="container-fluid">
		<div class="row">
			<div class="container">
				<div class="row">
	<div id="primary" class="home-content-area col-lg-12">
		<main id="main" class="site-main" role="main">

			<?php while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<header class="entry-header">
			<h1 class="homepage-entry-title"><?php the_title(); ?></h1>
			</header><!-- .entry-header -->

			<div class="entry-content">
			<?php the_content(); ?>
			<?php
			wp_link_pages( array(
			'before' => '<div class="page-links">' . __( 'Pages:', 'vryn-photography' ),
			'after'  => '</div>',
			) );
			?>
			</div><!-- .entry-content -->
			<?php edit_post_link( __( 'Edit', 'vryn-photography' ), '<footer class="entry-footer"><span class="edit-link">', '</span></footer>' ); ?>
			</article><!-- #post-## -->

				 

			<?php endwhile; // end of the loop. ?>

		</main><!-- #main -->
	</div><!-- #primary -->
	
				</div>
			</div>
		</div>
	</div>

	
 
<?php get_footer(); ?>