<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package VRYN Responsive
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="page" class="hfeed site">
	<div class="container-fluid top-header">
		<div class="row">
			<div class="container">
				<div class="row">
					
			<header id="masthead" class="site-header" role="banner">
				<div class="site-branding col-lg-4 col-md-4">
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
				</div>

				<nav id="site-navigation" class="main-navigation col-lg-8 col-md-8" role="navigation">
					<h1 class="menu-toggle"><?php _e( 'Menu', 'vryn-photography' ); ?></h1>
					<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'vryn-photography' ); ?></a>

					<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
				</nav><!-- #site-navigation -->
			</header><!-- #masthead -->
					
				</div>
			</div>
		</div>
	</div>
	
		<?php if (is_front_page()) { ?>
			<div class="slider-wrap">
			<?php 
				$slider_var = of_get_option('of_slider_shortcode');
				echo do_shortcode($slider_var); 
			?>
			</div>
		<?php } ?>
		
		<?php if ((!is_front_page())  && (of_get_option( 'display_slider', 'no entry' )=="0")) { ?>
			<div class="slider-wrap">
			<?php 
				$slider_var = of_get_option('of_slider_shortcode');
				echo do_shortcode($slider_var); 
			?>
			</div>
		<?php } ?>
	 

	<div id="content" class="site-content container-fluid">
		<div class="row">

