<?php
/**
 * @package vryn notes
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="accordion-2" id="section1">

	<header class="entry-header squeezhead">
		<?php the_title( sprintf( '<h1 class="entry-title accordion-title">', esc_url( get_permalink() ) ), '</h1>' ); ?>
		<span class="icon-arrow-left"></span>
	</header><!-- .entry-header -->
	<div class="squeezecnt">
		<?php if ( is_search() ) : // Only display Excerpts for Search ?>
		<div class="entry-summary">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		<?php else : ?>
		<div class="entry-content">
			<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'vryn-notes' ) ); ?>
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'vryn-notes' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
		<?php endif; ?>

		<footer class="entry-footer">
			<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
				<?php
					/* translators: used between list items, there is a space after the comma */
					$categories_list = get_the_category_list( __( ', ', 'vryn-notes' ) );
					if ( $categories_list && vryn_notes_categorized_blog() ) :
				?>
				<span class="cat-links">
					<?php printf( __( 'Posted in %1$s', 'vryn-notes' ), $categories_list ); ?>
				</span>
				<?php endif; // End if categories ?>

				<?php
					/* translators: used between list items, there is a space after the comma */
					$tags_list = get_the_tag_list( '', __( ', ', 'vryn-notes' ) );
					if ( $tags_list ) :
				?>
				<span class="tags-links">
					<?php printf( __( 'Tagged %1$s', 'vryn-notes' ), $tags_list ); ?>
				</span>
				<?php endif; // End if $tags_list ?>
			<?php endif; // End if 'post' == get_post_type() ?>

			<?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
			<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'vryn-notes' ), __( '1 Comment', 'vryn-notes' ), __( '% Comments', 'vryn-notes' ) ); ?></span>
			<?php endif; ?>

			<?php edit_post_link( __( 'Edit', 'vryn-notes' ), '<span class="edit-link">', '</span>' ); ?>
		</footer><!-- .entry-footer -->
		<a href="<?php the_permalink(); ?>">Readmore...</a>
		</div>
</div>
</article><!-- #post-## -->
