<?php
/**
 * vryn notes functions and definitions
 *
 * @package vryn notes
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'vryn_notes_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function vryn_notes_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on vryn notes, use a find and replace
	 * to change 'vryn-notes' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'vryn-notes', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'vryn-notes' ),
	) );

	// Enable support for Post Formats.
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );

	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'vryn_notes_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Enable support for HTML5 markup.
	add_theme_support( 'html5', array(
		'comment-list',
		'search-form',
		'comment-form',
		'gallery',
		'caption',
	) );
}
endif; // vryn_notes_setup
add_action( 'after_setup_theme', 'vryn_notes_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function vryn_notes_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'vryn-notes' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'vryn_notes_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function vryn_notes_scripts() {

	wp_enqueue_script("jquery");
	wp_enqueue_script( 'vryn-notes-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );
	wp_enqueue_script( 'vryn-notes-jquery_accordion', get_template_directory_uri() . '/js/squeezebox.js', array(), '20120206', true );
	wp_enqueue_script( 'vryn-notes-custom-jquery', get_template_directory_uri() . '/js/custom-jquery.js', array(), '20120206', true );

	wp_enqueue_script( 'vryn-notes-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'vryn_notes_scripts' );

if ( ! function_exists( 'vryn_notes_styles' ) ) {
     function vryn_notes_styles() {
         
        wp_enqueue_style( 'vryn_notes-bootstrap3', get_template_directory_uri().'/bootstrap/css/bootstrap.min.css');
		wp_enqueue_style( 'vryn_notes-style', get_stylesheet_uri() );
		wp_enqueue_style( 'vryn_notes-mobilemenu', get_template_directory_uri().'/mobilemenu.css');
		wp_enqueue_style( 'vryn_notes-custom-responsive', get_template_directory_uri().'/custom-responsive.css');
		wp_enqueue_style( 'vryn_notes-main-accordion', get_template_directory_uri().'/css/main.css');
        
     }
}
add_action( 'wp_enqueue_scripts', 'vryn_notes_styles' );

function vryn_notes_fonts() {
		wp_enqueue_style('vryn_notes-PT_Sans', '//fonts.googleapis.com/css?family=PT+Sans:400,700,400italic,700italic');
}
add_action( 'wp_enqueue_scripts', 'vryn_notes_fonts' );


/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
