<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package vryn notes
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<div class="container-fluid top-header">
		<div class="row">
			<div class="container">
				<div class="row">
					<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'vryn-notes' ); ?></a>

					<header id="masthead" class="site-header col-lg-12 col-md-12" role="banner">
						<div class="site-branding">
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
						</div>

						<nav id="site-navigation" class="main-navigation" role="navigation">
							<button class="menu-toggle"><?php _e( 'Primary Menu', 'vryn-notes' ); ?></button>
							<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
						</nav><!-- #site-navigation -->
					</header><!-- #masthead -->
				</div>
			</div>
		</div>
	</div>
	<div id="content" class="site-content container">
		<div class="row">
		